VAR
long cur_pos        'Real Position
long set_pos        'Set Point
long K              'PID Gain
long cur_error      'Current Error
long pre_error      'Previous Error
long output         'PID Output
long stack[30]      'COG Stack
byte cog            'cog number
long dt             'Integral Time

CON

OBJ

PUB Start(Current_Addr, Set_Addr, Gain, Integral_Time, Output_Addr) 
''Starts PID controller.  Starts a new cog to run in.
           ''Current_Addr  = Address of Long Variable holding actual position
           ''Set_Addr      = Address of Long Variable holding set point
           ''Gain          = PID Algorithm Gain, ie: large gain = large changes faster, though less precise overall
           ''Integral_Time = PID Algorithm Integral_Time
           ''Output_Addr   = Address of Long Variable wich holds output of PID algorithm

cur_pos := Current_Addr
set_pos := Set_Addr
K := Gain
dt := Integral_Time
output := Output_Addr

pre_error := 0
cur_error := 0

cog := cognew(Loop, @stack)

PUB Stop
''Stops the Cog and the PID controller
cogstop(cog)

PRI Loop | e, P, I, D

repeat
  long[cur_error] := long[set_pos] - long[cur_pos]
  P := K * long[cur_error]
  
  I := I + K * long[cur_error] * dt
  
  e := long[cur_error] - long[pre_error]
  D := K * e / dt

  long[output] := P + I + D